/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.weapon;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class CircleWeaponAttack
implements IWeaponAttack {
    public static final Loader LOADER = new Loader();
    private final float radius;

    @Override
    public boolean dealDamage(IToolStackView tool, ToolAttackContext context, float damage) {
        boolean hit = ToolAttackUtil.dealDefaultDamage(context.getAttacker(), context.getTarget(), damage);
        if (context.isFullyCharged()) {
            double range = this.radius + (float)tool.getModifierLevel(TinkerModifiers.expanded.getId());
            if (this.radius > 0.0f) {
                double rangeSq = range * range;
                LivingEntity attacker = context.getAttacker();
                Entity target = context.getTarget();
                for (LivingEntity aoeTarget : attacker.f_19853_.m_45976_(LivingEntity.class, target.m_142469_().m_82377_(range, 0.25, range))) {
                    ArmorStand stand;
                    if (aoeTarget == attacker || aoeTarget == target || attacker.m_7307_((Entity)aoeTarget) || aoeTarget instanceof ArmorStand && (stand = (ArmorStand)aoeTarget).m_31677_() || !(target.m_20280_((Entity)aoeTarget) < rangeSq)) continue;
                    float angle = attacker.m_146908_() * ((float)Math.PI / 180);
                    aoeTarget.m_147240_((double)0.4f, (double)Mth.m_14031_((float)angle), (double)(-Mth.m_14089_((float)angle)));
                    hit |= ToolAttackUtil.extraEntityAttack(tool, attacker, context.getHand(), (Entity)aoeTarget);
                }
                attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    player.m_36346_();
                }
            }
        }
        return hit;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IWeaponAttack> getLoader() {
        return LOADER;
    }

    public CircleWeaponAttack(float radius) {
        this.radius = radius;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<CircleWeaponAttack> {
        private Loader() {
        }

        public CircleWeaponAttack deserialize(JsonObject json) {
            return new CircleWeaponAttack(GsonHelper.m_13915_((JsonObject)json, (String)"diameter"));
        }

        public CircleWeaponAttack fromNetwork(FriendlyByteBuf buffer) {
            return new CircleWeaponAttack(buffer.readFloat());
        }

        public void serialize(CircleWeaponAttack object, JsonObject json) {
            json.addProperty("diameter", (Number)Float.valueOf(object.radius));
        }

        public void toNetwork(CircleWeaponAttack object, FriendlyByteBuf buffer) {
            buffer.writeFloat(object.radius);
        }
    }
}

